<?php
require_once 'config.php';
requireLogin();

// الحصول على الصفحة المطلوبة
$page = $_GET['page'] ?? 'home';

// إحصائيات سريعة
$total_cars = $conn->query("SELECT COUNT(*) as count FROM cars")->fetch_assoc()['count'];
$available_cars = $conn->query("SELECT COUNT(*) as count FROM cars WHERE status = 'available'")->fetch_assoc()['count'];
$total_bookings = $conn->query("SELECT COUNT(*) as count FROM bookings")->fetch_assoc()['count'];
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - نظام إدارة السيارات</title>
    <link rel="stylesheet" href="dashboard.css">
</head>
<body>
    <!-- الشريط الجانبي -->
    <div class="sidebar">
        <div class="logo">
            <h2>🚗 نظام السيارات</h2>
        </div>
        
        <nav class="nav-menu">
            <a href="?page=home" class="nav-item <?php echo $page == 'home' ? 'active' : ''; ?>">
                <span class="icon">🏠</span> الرئيسية
            </a>
            <a href="?page=about" class="nav-item <?php echo $page == 'about' ? 'active' : ''; ?>">
                <span class="icon">ℹ️</span> عن النظام
            </a>
            <a href="?page=services" class="nav-item <?php echo $page == 'services' ? 'active' : ''; ?>">
                <span class="icon">⚙️</span> الخدمات
            </a>
            <a href="?page=cars" class="nav-item <?php echo $page == 'cars' ? 'active' : ''; ?>">
                <span class="icon">🚙</span> السيارات
            </a>
            <a href="?page=add-car" class="nav-item <?php echo $page == 'add-car' ? 'active' : ''; ?>">
                <span class="icon">➕</span> إضافة سيارة
            </a>
            <a href="?page=bookings" class="nav-item <?php echo $page == 'bookings' ? 'active' : ''; ?>">
                <span class="icon">📋</span> الحجوزات
            </a>
            <a href="?page=contact" class="nav-item <?php echo $page == 'contact' ? 'active' : ''; ?>">
                <span class="icon">📞</span> اتصل بنا
            </a>
            <a href="?page=export" class="nav-item <?php echo $page == 'export' ? 'active' : ''; ?>">
                <span class="icon">📤</span> تصدير البيانات
            </a>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <span>👤 <?php echo htmlspecialchars($_SESSION['username']); ?></span>
            </div>
            <a href="logout.php" class="btn-logout">تسجيل الخروج</a>
        </div>
    </div>

    <!-- المحتوى الرئيسي -->
    <div class="main-content">
        <div class="top-bar">
            <h1><?php 
                $titles = [
                    'home' => 'لوحة التحكم الرئيسية',
                    'about' => 'عن النظام',
                    'services' => 'الخدمات',
                    'cars' => 'إدارة السيارات',
                    'add-car' => 'إضافة سيارة جديدة',
                    'bookings' => 'إدارة الحجوزات',
                    'contact' => 'اتصل بنا',
                    'export' => 'تصدير البيانات'
                ];
                echo $titles[$page] ?? 'لوحة التحكم';
            ?></h1>
        </div>

        <div class="content-area">
            <?php
            // تضمين الصفحة المناسبة
            switch($page) {
                case 'home':
                    include 'pages/home.php';
                    break;
                case 'about':
                    include 'pages/about.php';
                    break;
                case 'services':
                    include 'pages/services.php';
                    break;
                case 'cars':
                    include 'pages/cars.php';
                    break;
                case 'add-car':
                    include 'pages/add-car.php';
                    break;
                case 'bookings':
                    include 'pages/bookings.php';
                    break;
                case 'contact':
                    include 'pages/contact.php';
                    break;
                case 'export':
                    include 'pages/export.php';
                    break;
                default:
                    include 'pages/home.php';
            }
            ?>
        </div>
    </div>
</body>
</html>